'use strict';

/**
 * Receives notifications about server-side communication latencies
 */

Object.defineProperty(exports, "__esModule", {
  value: true
});
class LatencyListener {

  /**
   * Object containing request latency information
   * @typedef {Object} ResponseTimestamps
   * @property {Date} clientProcessingStarted time when request processing have started on client side
   * @property {Date} serverProcessingStarted time when request processing have started on server side
   * @property {Date} serverProcessingFinished time when request processing have finished on server side
   * @property {Date} clientProcessingFinished time when request processing have finished on client side
   */

  /**
   * Invoked with latency information when application receives a response to RPC request
   * @param {string} accountId account id
   * @param {string} type request type
   * @param {ResponseTimestamps} timestamps request timestamps object containing latency information
   * @return {Promise} promise which resolves when latency information is processed
   */
  async onResponse(accountId, type, timestamps) {}

  /**
   * Timestamps object containing latency information about price streaming
   * @typedef {Object} SymbolPriceTimestamps
   * @property {Date} eventGenerated time the event was generated on exchange side
   * @property {Date} serverProcessingStarted time the event processing have started on server side
   * @property {Date} serverProcessingFinished time the event processing have finished on server side
   * @property {Date} clientProcessingFinished time the event processing have finished on client side
   */

  /**
   * Invoked with latency information when application receives symbol price update event
   * @param {string} accountId account id
   * @param {string} symbol price symbol
   * @param {SymbolPriceTimestamps} timestamps timestamps object containing latency information about price streaming
   * @return {Promise} promise which resolves when latency information is processed
   */
  async onSymbolPrice(accountId, symbol, timestamps) {}

  /**
   * Timestamps object containing latency information about update streaming
   * @typedef {Object} UpdateTimestamps
   * @property {Date} eventGenerated time the event was generated on exchange side
   * @property {Date} serverProcessingStarted time the event processing have started on server side
   * @property {Date} serverProcessingFinished time the event processing have finished on server side
   * @property {Date} clientProcessingFinished time the event processing have finished on client side
   */

  /**
   * Invoked with latency information when application receives update event
   * @param {string} accountId account id
   * @param {UpdateTimestamps} timestamps timestamps object containing latency information about update streaming
   * @return {Promise} promise which resolves when latency information is processed
   */
  async onUpdate(accountId, timestamps) {}

  /**
   * Timestamps object containing latency information about a trade
   * @typedef {Object} TradeTimestamps
   * @property {Date} clientProcessingStarted time when request processing have started on client side
   * @property {Date} serverProcessingStarted time the event processing have started on server side
   * @property {Date} serverProcessingFinished time the event processing have finished on server side
   * @property {Date} clientProcessingFinished time the event processing have finished on client side
   * @property {Date} tradeStarted time the trade execution was started on server side
   * @property {Date} tradeExecuted time the trade was executed on exchange side
   */

  /**
   * Invoked with latency information when application receives trade response
   * @param {string} accountId account id
   * @param {TradeTimestamps} timestamps timestamps object containing latency information about a trade
   * @return {Promise} promise which resolves when latency information is processed
   */
  async onTrade(accountId, timestamps) {}

}
exports.default = LatencyListener;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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